'strict'

var toggler = document.getElementsByClassName("caret");
var i;

for (i = 0; i < toggler.length; i++) {
  toggler[i].addEventListener("click", function() {
    this.parentElement.querySelector(".nested").classList.toggle("active");
    this.classList.toggle("caret-down");
  });
}

function unmark_recursive(ul_ele){
  for(var i = 0; i < ul_ele.children.length; i++){
    var li_ele = ul_ele.children[i];
    
    if(li_ele.children.length < 2) continue;
    
    if(li_ele.children[0].id.length < 1){
      li_ele.children[1].classList.remove("found-mark");
    }else{
      li_ele.children[0].classList.remove("found-mark");
    }
    
    var new_ul = li_ele.querySelector(".nested");
    
    if(!new_ul) continue;
    
    unmark_recursive(new_ul);
  }
}

function close_tree_recursive(ul_ele){
  for(var i = 0; i < ul_ele.children.length; i++){
    var li_ele = ul_ele.children[i];
    
    if(li_ele.children.length < 2) continue;
    
    var a = li_ele.querySelector(".caret");
    
    if(!a) continue;
    
    a.classList.remove("caret-down");
    
    var new_ul = li_ele.querySelector(".nested");
    new_ul.classList.remove("active");
    close_tree_recursive(new_ul);
  }
}

function open_tree_climb(li_ele){
  if(li_ele.children.length > 1 && li_ele.querySelector(".caret")) {
    var a = li_ele.querySelector(".caret");
    
    if(a){
      a.classList.add("caret-down");
      
      var new_ul = li_ele.querySelector(".nested");
      new_ul.classList.add("active");
    }
  }
  
  if(li_ele.parentElement.id !== "myUL")
    open_tree_climb(li_ele.parentElement.parentElement);
}

function use_search_bar_recursive(ul_ele, search_text){
  for(var i = 0; i < ul_ele.children.length; i++){
    var li_ele = ul_ele.children[i];
    
    if(li_ele.children.length < 2) continue;
    // console.log(li_ele.children.length);
    
    // console.log(li_ele.children[0].id);
    if(li_ele.children[0].id.length < 1){
      var str1 = li_ele.children[1].id.substring(li_ele.children[1].id.lastIndexOf("/")+1);
      
      if(str1.search(search_text) != -1){
        li_ele.children[1].classList.add("found-mark");
        open_tree_climb(li_ele);
      }
    }else{
      var str1 = li_ele.children[0].id.substring(li_ele.children[0].id.lastIndexOf("/")+1);
      
      if(str1.search(search_text) != -1){
        li_ele.children[0].classList.add("found-mark");
        open_tree_climb(li_ele);
      }
      
      var new_ul = li_ele.querySelector(".nested");
      if(new_ul != null){
        use_search_bar_recursive(new_ul, search_text);
      }
    }
  }
}

const obj_search_ele = document.getElementById("obj_search");
obj_search_ele.oninput = function(){
  var node_ele = document.getElementById("myUL");
  unmark_recursive(node_ele);
  
  if(obj_search_ele.value.length < 1) return;
  close_tree_recursive(node_ele);
  use_search_bar_recursive(node_ele, obj_search_ele.value);
};


/*
var wls = window.location.search;
if(wls.indexOf("path=") != -1){
  wls = wls.substr(wls.indexOf("path=")+5);
}

if(wls.indexOf("&") != -1){
  wls = wls.substr(0,wls.indexOf("&"));
}

while(wls.length > 1){
  wls = wls.substr(0,wls.lastIndexOf("/"));
  if(wls == "") wls = "/";
  var node_ele = document.getElementById(wls);
  node_ele.parentElement.querySelector(".nested").classList.toggle("active");
  node_ele.classList.toggle("caret-down");
}
*/

