
/**************************************************************************
 *
 *  $Id: pcpslstr.h 1.36 2023/02/21 10:16:13Z martin.burnicki REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for pcpslstr.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: pcpslstr.h $
 *  Revision 1.36  2023/02/21 10:16:13Z  martin.burnicki
 *  Removed trailing spaces.
 *  Revision 1.35  2021/03/22 23:11:52  martin
 *  Updated some comments.
 *  Revision 1.34  2021/03/12 12:32:57  martin
 *  Updated some comments.
 *  Revision 1.33  2020/02/27 13:52:25  martin
 *  Account for a renamed library function.
 *  Updated function prototypes.
 *  Revision 1.32  2018/12/11 16:03:11  martin
 *  Updated function prototypes.
 *  Revision 1.31  2018/01/15 18:25:16Z  martin
 *  Updated function prototypes.
 *  Revision 1.30  2017/07/05 17:37:03  martin
 *  Check for MBG_TGT_POSIX instead of MBG_TGT_UNIX.
 *  Account for new modes for programmable pulse outputs.
 *  Started to add doxygen comments.
 *  Fixed typos, wording, and doxygen comments.
 *  Updated function prototypes.
 *  Revision 1.29  2012/11/20 10:47:29  martin
 *  Moved some code definitions for special chars
 *  to new header charcode.h.
 *  Revision 1.28  2012/10/15 13:01:23  martin
 *  Include cfg_hlp.h.
 *  Made all declarations extern C.
 *  Added menu titles for PTP and PTP Unicast configuration.
 *  Added DEFAULT_OPT_NAME_TR_DISTANCE.
 *  Support time slots mode for programmable pulse outputs.
 *  Added strings for programmable output synthesizer mode.
 *  Fixed build on FreeBSD.
 *  Also use ANSI umlauts on QNX.
 *  Updated function prototypes.
 *  Revision 1.27  2010/06/28 08:28:17Z  stefan
 *  Added greek character mu.
 *  Corrected a spelling mistake.
 *  Defined umlauts as hex codes.
 *  Added _pcps_sprint_vernum macro which is either _dec or _hex,
 *  depending on the target platform.
 *  Revision 1.26  2010/06/25 13:58:25  daniel
 *  Added IgnoreTFOM related language strings
 *  Revision 1.25  2010/01/28 09:02:27  martin
 *  Added menu option name for LAN interface.
 *  Added German POUT mode names for DCF77_M59.
 *  Revision 1.24  2009/03/19 08:07:45Z  daniel
 *  Updated function prototypes.
 *  Revision 1.23  2008/11/14 12:12:45Z  martin
 *  Updated function prototypes.
 *  Revision 1.22  2008/01/17 09:12:41Z  daniel
 *  Use mbg_tgt.h, specially to care about wchar_t.
 *  Added strings for WEZ/WESZ, BST, GMT.
 *  Updated function prototypes.
 *  Revision 1.21  2007/03/30 13:24:42Z  martin
 *  Added initializer for status string if time has been set manually.
 *  Revision 1.20  2007/03/29 12:59:23Z  martin
 *  Moved some definitions here.
 *  Added and modified some definitions related to TZCODE.
 *  Revision 1.19  2006/10/23 15:18:15Z  martin
 *  Added some configuration warning msg texts.
 *  Added definitions for uppercase umlauts.
 *  Separated English and German initializers for some strings.
 *  Revision 1.18  2006/09/26 14:57:22Z  martin
 *  Added DEFAULT_OPT_NAME_POUT.
 *  Revision 1.17  2000/07/02 07:02:16Z  martin
 *  Separate English and German initializers for "invalid time".
 *  Revision 1.16  2006/05/23 20:13:24Z  martin
 *  Added initializers for German POUT mode strings.
 *  Revision 1.15  2005/12/20 10:30:56Z  martin
 *  Made some strings start with uppercase letters.
 *  Revision 1.14  2005/08/12 12:35:34Z  martin
 *  Fixed missing comma in a macro.
 *  Revision 1.13  2005/03/03 08:49:38Z  martin
 *  Modified DEFAULT_OPT_NAME_SERIAL.
 *  Modified DEFAULT_OPT_NAME_IRIG_...
 *  Added default strings for synthesizer.
 *  Revision 1.12  2004/11/23 09:36:12Z  martin
 *  Fixed a typo.
 *  Revision 1.11  2004/11/09 15:08:08Z  martin
 *  Defined some separate strings for English and German.
 *  Modified some string contents.
 *  Revision 1.10  2004/10/26 15:03:57  martin
 *  Distinguish between IRIG RX and TX strings.
 *  Revision 1.9  2004/08/18 14:59:04Z  martin
 *  Defined some flag bits to control the format of the output string
 *  generated by pcps_tz_name().
 *  Updated function prototypes.
 *  Revision 1.8  2004/04/07 12:49:06Z  martin
 *  Added initializers for IRIG output cfg strings.
 *  Revision 1.7  2003/04/15 10:47:29Z  martin
 *  Added initializers for IRIG menu strings.
 *  Updated function prototypes.
 *  Revision 1.6  2002/12/18 13:57:53  martin
 *  Some definitions and variables made global.
 *  Added some new macros _pcps_sprint_vernum...()
 *  and _pcps_sprint_dev_id().
 *  Revision 1.5  2002/02/19 10:01:36Z  MARTIN
 *  New initializers for string mode names.
 *  New global variables mode_name and short_mode_name.
 *  Updated function prototypes.
 *  Revision 1.4  2001/09/17 13:26:16  MARTIN
 *  Added definitions for PCPS_STATUS_STRS.
 *  Added initializers for strings.
 *  Added some comments.
 *  Updated function prototypes.
 *  Revision 1.3  2001/08/14 11:35:40  MARTIN
 *  Added initializers for commonly used mulit-language
 *  text strings.
 *  Revision 1.2  2001/02/28 15:48:34  MARTIN
 *  Updated function prototypes.
 *  Modified syntax to initialize variables.
 *  Revision 1.1  2000/07/21 12:15:12  MARTIN
 *  Initial revision
 *
 **************************************************************************/

#ifndef _PCPSLSTR_H
#define _PCPSLSTR_H


/* Other headers to be included */

#include <str_util.h>
#include <charcode.h>
#include <cfg_hlp.h>
#include <pcpsdev.h>
#include <ctrydttm.h>
#include <cnv_wday.h>


#ifdef _PCPSLSTR
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif


#if defined( MBG_TGT_WIN32 ) \
 || defined( MBG_TGT_POSIX ) \
 || defined( MBG_TGT_QNX )

  #define DEFAULT_PCPS_WDAY_DATE_DIST   1
  #define DEFAULT_PCPS_DATE_TIME_DIST   2
  #define DEFAULT_PCPS_TIME_TZ_DIST     1

#else

  #define DEFAULT_PCPS_WDAY_DATE_DIST   1
  #define DEFAULT_PCPS_DATE_TIME_DIST   2
  #define DEFAULT_PCPS_TIME_TZ_DIST     1

#endif



/**
 * @brief Flag bits used to define ::PCPS_TZ_NAME_FLAGS.
 *
 * @see ::PCPS_TZ_NAME_FLAGS
 */
enum PCPS_TZ_NAME_BITS
{
  PCPS_TZ_NAME_BIT_FORCE_UTC_OFFS, ///< Always print "UTC+offs".
  PCPS_TZ_NAME_BIT_APP_DST,        ///< Append DST status.
  N_PCPS_TZ_NAME_FLAG
};


/**
 * @brief Flag bits used to control the string generated by ::pcps_tz_name.
 *
 * The flags defined can be passed to ::pcps_tz_name to control
 * the formatting of the generated time zone names.
 *
 * @see ::pcps_tz_name
 * @see ::PCPS_TZ_NAME_BITS
 */
enum PCPS_TZ_NAME_FLAGS
{
  PCPS_TZ_NAME_FORCE_UTC_OFFS = ( 1UL << PCPS_TZ_NAME_BIT_FORCE_UTC_OFFS ), ///< See ::PCPS_TZ_NAME_FORCE_UTC_OFFS.
  PCPS_TZ_NAME_APP_DST        = ( 1UL << PCPS_TZ_NAME_BIT_APP_DST ),        ///< See ::PCPS_TZ_NAME_APP_DST.
};



/**
 * @defgroup group_status_strs Definitions used with ::pcps_get_status_strs
 *
 * @{ */

#define N_PCPS_STATUS_STR   3

typedef struct
{
  const char *cp;
  int is_err;
} PCPS_STATUS_STR;

typedef struct
{
  PCPS_STATUS_STR s[N_PCPS_STATUS_STR];
} PCPS_STATUS_STRS;

/** @} defgroup group_status_strs */



// Initializers for commonly use multi-language strings.
// (type: CLSTR )


// Time adjustment window.

#define DEFAULT_STR_TIME_ADJ_STATUS  \
{                                    \
  "Time Adjustment Status",          \
  "Status der Zeitkontrolle"         \
}

#define DEFAULT_STR_SYS_TIME  \
{                             \
  "System Time:",             \
  "Systemzeit:"               \
}

#define DEFAULT_STR_REF_TIME  \
{                             \
  "Reference Time:",          \
  "Referenzzeit:"             \
}

#define DEFAULT_STR_DELTA_TIME  \
{                               \
  "Difference:",                \
  "Zeitdifferenz:"              \
}

#define DEFAULT_STR_LAST_CORR  \
{                              \
  "Last Correction:",          \
  "Letzte Korrektur:"          \
}

#define DEFAULT_STR_WAIT_SYNC          \
{                                      \
  "Waiting for Sync After Reset ...",  \
  "Warte auf Sync. nach Reset ..."     \
}


// Ref time window.

#define DEFAULT_STR_REF_TIME_INFO  \
{                                  \
  "Reference Time Info",           \
  "Referenzzeit"                   \
}

#define DEFAULT_STR_REF_SRC_LABEL  \
{                                  \
  "Time Source:",                  \
  "Funkuhr ID:"                    \
}

#define DEFAULT_STR_REF_SYNC_LABEL  \
{                                   \
  "Last Sync.:",                    \
  "Letzte Sync.:"                   \
}


// Device status messages:

// Time is not valid (e.g. after batt. empty).
#define DEFAULT_STR_TIME_INVAL_EN \
  "Ref. Time is Invalid"

#define DEFAULT_STR_TIME_INVAL_DE \
  "Referenzzeit nicht g" LCUE "ltig"

#define DEFAULT_STR_TIME_INVAL \
{                              \
  DEFAULT_STR_TIME_INVAL_EN,   \
  DEFAULT_STR_TIME_INVAL_DE    \
}

// On-board time has been set manually.
#define DEFAULT_STR_SET_MANUALLY \
{                                \
  "Time has been set manually",  \
  "Zeit wurde manuell gesetzt"   \
}

// DCF77 receiver has synch'd at least once
// after reset.
#define DEFAULT_STR_DCF_HAS_SYNCD   \
{                                   \
  "Synchronized after last RESET",  \
  "Sync. nach RESET ist erfolgt"    \
}

// DCF77 receiver has not synch'd after reset.
#define DEFAULT_STR_DCF_HAS_NOT_SYNCD    \
{                                        \
  "Not synchronized after last RESET",   \
  "Sync. nach RESET noch nicht erfolgt"  \
}

// DCF77 receiver currently runs on XTAL.
#define DEFAULT_STR_DCF_FREE_RUNNING          \
{                                             \
  "Clock running on Xtal oscillator",         \
  "Funkuhr l" LCAE "uft frei auf Quarzbasis"  \
}

// DCF77 receiver is currently synchronized.
#define DEFAULT_STR_DCF_NOT_FREE_RUNNING      \
{                                             \
  "Clock is synchronized",                    \
  "Senderf" LCUE "hrung"                      \
}

// GPS receiver is currently synchronized.
#define DEFAULT_STR_GPS_SYNCD        \
{                                    \
  "Time is synchronized",            \
  "Zeitsynchronisation ist erfolgt"  \
}

// GPS receiver is currently synchronized.
#define DEFAULT_STR_GPS_NOT_SYNCD    \
{                                    \
  "Time not synchronized",           \
  "Zeit ist nicht synchron"          \
}

// GPS receiver has verified its position.
#define DEFAULT_STR_GPS_POS_OK             \
{                                          \
  "Receiver position has been verified",   \
  "Positionbestimmung durchgef" LCUE "hrt" \
}

// GPS receiver has not verified its position.
#define DEFAULT_STR_GPS_POS_NOT_OK      \
{                                       \
  "Receiver pos. not verified",         \
  "Position nicht gepr" LCUE "ft"       \
}

// Announcement of DST change.
#define DEFAULT_STR_ANN_DST               \
{                                         \
  "Change in Daylight Saving Announced",  \
  "Zeitumschaltung angek" LCUE "ndigt"    \
}

// Announcement of leap second.
#define DEFAULT_STR_ANN_LS                \
{                                         \
  "Leap Second Announced",                \
  "Schaltsekunde angek" LCUE "ndigt"      \
}


// Menu option: Setup (title).

#define DEFAULT_OPT_NAME_SETUP_EN \
  "Setup"

#define DEFAULT_OPT_NAME_SETUP_DE \
  "Einstellungen"

#define DEFAULT_OPT_NAME_SETUP \
{                              \
  DEFAULT_OPT_NAME_SETUP_EN,   \
  DEFAULT_OPT_NAME_SETUP_DE    \
}


// Menu option: Setup date/time.

#define DEFAULT_OPT_NAME_SET_TIME_EN \
  "Onboard Date/Time"

#define DEFAULT_OPT_NAME_SET_TIME_DE \
  "Datum/Zeit der Funkuhr"

#define DEFAULT_OPT_NAME_SET_TIME \
{                                 \
  DEFAULT_OPT_NAME_SET_TIME_EN,   \
  DEFAULT_OPT_NAME_SET_TIME_DE    \
}

#define DEFAULT_STR_NEW_DATE  \
{                             \
  "New date",                 \
  "Neues Datum"               \
}

#define DEFAULT_STR_NEW_TIME  \
{                             \
  "New time",                 \
  "Neue Zeit"                 \
}


// Menu option: Setup time zone.

#define TZ_NAME_UTC    "UTC"

#define TZ_NAME_MEZ    "MEZ"
#define TZ_NAME_MESZ   "MESZ"
#define TZ_NAME_CET    "CET"
#define TZ_NAME_CEST   "CEST"

#define TZ_NAME_OEZ    "OEZ"
#define TZ_NAME_OESZ   "OESZ"
#define TZ_NAME_EET    "EET"
#define TZ_NAME_EEST   "EEST"

#define TZ_NAME_WEZ    "WEZ"
#define TZ_NAME_WESZ   "WESZ"
#define TZ_NAME_GMT    "GMT"
#define TZ_NAME_BST    "BST"

#define DEFAULT_OPT_NAME_TZ  \
{                            \
  "Onboard Time Zone",       \
  "Zeitzone der Funkuhr"     \
}


// Menu option: Setup time zone.

#define DEFAULT_TZCODE_NAME_CET_CEST \
{                                    \
  TZ_NAME_CET "/" TZ_NAME_CEST,      \
  TZ_NAME_MEZ "/" TZ_NAME_MESZ       \
}

#define DEFAULT_TZCODE_HINT_CET_CEST                                      \
{                                                                         \
  "Central European Time or Summer Time, as broadcast by DCF77",          \
  "Mitteleurop" LCAE "ische Zeit oder Sommerzeit, wie von DCF77 gesendet" \
}

#define DEFAULT_TZCODE_NAME_GMT_BST \
{                                   \
  TZ_NAME_GMT "/" TZ_NAME_BST,      \
  TZ_NAME_WEZ "/" TZ_NAME_WESZ      \
}

#define DEFAULT_TZCODE_HINT_GMT_BST                                    \
{                                                                      \
  "Greenwich Mean Time or British Summer Time, as broadcast by MSF",   \
  "Westeurop" LCAE "ische Zeit oder britische Sommerzeit, wie von MSF gesendet"  \
}



#define DEFAULT_TZCODE_NAME_CET \
{                               \
  "always " TZ_NAME_CET,        \
  "immer " TZ_NAME_MEZ          \
}

#define DEFAULT_TZCODE_HINT_CET                            \
{                                                          \
  "always CET (UTC+1h), daylight saving suppressed",       \
  "immer MEZ (UTC+1h), Sommerzeit wird unterdr" LCUE "ckt" \
}


#define DEFAULT_TZCODE_NAME_UTC \
{                               \
  TZ_NAME_UTC,                  \
  TZ_NAME_UTC                   \
}

#define DEFAULT_TZCODE_HINT_UTC \
{                               \
  "always UTC",                 \
  "immer UTC"                   \
}


#define DEFAULT_TZCODE_NAME_EET_EEST \
{                                    \
  TZ_NAME_EET "/" TZ_NAME_EEST,      \
  TZ_NAME_OEZ "/" TZ_NAME_OESZ       \
}

#define DEFAULT_TZCODE_HINT_EET_EEST            \
{                                               \
  "East European Time, CET/CEST + 1h",          \
  "Osteurop" LCAE "ische Zeit, MEZ/MESZ + 1h"   \
}


#define DEFAULT_TZCODE_NAMES    \
{                               \
  DEFAULT_TZCODE_NAME_CET_CEST, \
  DEFAULT_TZCODE_NAME_CET,      \
  DEFAULT_TZCODE_NAME_UTC,      \
  DEFAULT_TZCODE_NAME_EET_EEST  \
}

#define DEFAULT_TZCODE_HINTS      \
{                                 \
  DEFAULT_TZCODE_HINT_CET_CEST,   \
  DEFAULT_TZCODE_HINT_CET,        \
  DEFAULT_TZCODE_HINT_UTC,        \
  DEFAULT_TZCODE_HINT_EET_EEST    \
}


// Menu option: Setup serial parameters.

#define DEFAULT_OPT_NAME_SERIAL        \
{                                      \
  "On-Board Serial Ports",             \
  "Serielle Schnittstellen der Karte"  \
}


// Menu option: Setup enable flags.

#define DEFAULT_OPT_NAME_EF            \
{                                      \
  "Enable Outputs",                    \
  "Freischaltung der Ausg" LCAE "nge"  \
}


// Menu option: Setup length of antenna cable.

#define DEFAULT_OPT_NAME_CAB_LEN  \
{                                 \
  "Antenna Cable",                \
  "Antennenkabel"                 \
}


// Menu option: Setup distance from transmitter.

#define DEFAULT_OPT_NAME_TR_DISTANCE \
{                                    \
  "Distance from Transmitter",       \
  "Senderentfernung"                 \
}


// Menu option: Setup IRIG config.

#define DEFAULT_OPT_NAME_IRIG_TX_EN  "IRIG Output"
#define DEFAULT_OPT_NAME_IRIG_TX_DE  "IRIG-Ausgang"

#define DEFAULT_OPT_NAME_IRIG_TX  \
{                                 \
  DEFAULT_OPT_NAME_IRIG_TX_EN,    \
  DEFAULT_OPT_NAME_IRIG_TX_DE     \
}


#define DEFAULT_OPT_NAME_IRIG_RX_EN  "IRIG Input"
#define DEFAULT_OPT_NAME_IRIG_RX_DE  "IRIG-Eingang"

#define DEFAULT_OPT_NAME_IRIG_RX  \
{                                 \
  DEFAULT_OPT_NAME_IRIG_RX_EN,    \
  DEFAULT_OPT_NAME_IRIG_RX_DE     \
}


#define DEFAULT_STR_IRIG_FMT_EN  "IRIG Code Format"
#define DEFAULT_STR_IRIG_FMT_DE  "IRIG Code-Format"

#define DEFAULT_STR_IRIG_FMT \
{                            \
  DEFAULT_STR_IRIG_FMT_EN,   \
  DEFAULT_STR_IRIG_FMT_DE    \
}


#define DEFAULT_STR_IRIG_OFFS_EN  "IRIG Time Offset from UTC"
#define DEFAULT_STR_IRIG_OFFS_DE  "IRIG-Zeitoffset zu UTC"

#define DEFAULT_STR_IRIG_OFFS \
{                             \
  DEFAULT_STR_IRIG_OFFS_EN,   \
  DEFAULT_STR_IRIG_OFFS_DE    \
}


#define DEFAULT_STR_IRIG_TIMESTR_UTC_EN  "Send serial UTC"
#define DEFAULT_STR_IRIG_TIMESTR_UTC_DE  "Seriell UTC ausgeben"

#define DEFAULT_STR_IRIG_TIMESTR_UTC \
{                                    \
  DEFAULT_STR_IRIG_TIMESTR_UTC_EN,   \
  DEFAULT_STR_IRIG_TIMESTR_UTC_DE    \
}


#define DEFAULT_STR_IRIG_OUTPUT_LOC_TM_EN  "Transmit local time instead of UTC"
#define DEFAULT_STR_IRIG_OUTPUT_LOC_TM_DE  "Ortszeit statt UTC aussenden"

#define DEFAULT_STR_IRIG_OUTPUT_LOC_TM \
{                                      \
  DEFAULT_STR_IRIG_OUTPUT_LOC_TM_EN,   \
  DEFAULT_STR_IRIG_OUTPUT_LOC_TM_DE    \
}

#define DEFAULT_IGNORE_RX_TFOM_EN  "Ignore TFOM"
#define DEFAULT_IGNORE_RX_TFOM_DE  "Ignoriere TFOM"

#define DEFAULT_IGNORE_RX_TFOM       \
{                                    \
  DEFAULT_IGNORE_RX_TFOM_EN,         \
  DEFAULT_IGNORE_RX_TFOM_DE          \
}

#define DEFAULT_STR_TFOM_ALWAYS_SYNC_EN  "Output TFOM always as 'sync'"
#define DEFAULT_STR_TFOM_ALWAYS_SYNC_DE  "TFOM immer als 'sync' ausgeben"

#define DEFAULT_STR_TFOM_ALWAYS_SYNC \
{                                    \
  DEFAULT_STR_TFOM_ALWAYS_SYNC_EN,   \
  DEFAULT_STR_TFOM_ALWAYS_SYNC_DE    \
}


#define DEFAULT_STR_IRIG_NOT_CFGD_EN \
  "The IRIG receiver has not yet been configured!\n" \
  "\n" \
  "Please make sure the correct " DEFAULT_STR_IRIG_FMT_EN " has been\n" \
  "selected, and enter the correct " DEFAULT_STR_IRIG_OFFS_EN "\n" \
  "according to the settings of the IRIG generator."

#define DEFAULT_STR_IRIG_NOT_CFGD_DE \
  "Der IRIG-Empf" LCAE "nger wurde noch nicht konfiguriert!\n" \
  "\n" \
  "Das ausgew" LCAE "hlte " DEFAULT_STR_IRIG_FMT_DE " sowie der\n" \
  DEFAULT_STR_IRIG_OFFS_DE " m" LCUE "ssen den Einstellungen\n" \
  "des verwendeten IRIG-Generators entsprechen."

#define DEFAULT_STR_IRIG_NOT_CFGD \
{                                 \
  DEFAULT_STR_IRIG_NOT_CFGD_EN,   \
  DEFAULT_STR_IRIG_NOT_CFGD_DE    \
}


#define DEFAULT_STR_IRIG_INVT_EN \
  "Please note that the IRIG receiver status may read\n" \
  "\"" DEFAULT_STR_TIME_INVAL_EN "\" if the receiver's on-board date\n" \
  "does not correspond to the date (day-of-year number)\n" \
  "transmitted by the IRIG source."

#define DEFAULT_STR_IRIG_INVT_DE \
  "Wenn im Status des IRIG-Empf" LCAE "ngers \"" DEFAULT_STR_TIME_INVAL_DE "\"\n" \
  "angezeigt wird, kann der Grund daf" LCUE "r sein, dass das Datum\n" \
  "auf der Einsteckkarte nicht mit dem vom IRIG-Generator\n" \
  "gesendeten Datum (bzw. dem Jahrestag) " LCUE "bereinstimmt." \

#define DEFAULT_STR_IRIG_INVT \
{                             \
  DEFAULT_STR_IRIG_INVT_EN,   \
  DEFAULT_STR_IRIG_INVT_DE    \
}


// Menu option: Programmable outputs.

#define DEFAULT_OPT_NAME_POUT             \
{                                         \
  "Programmable Pulse Outputs",           \
  "Programmierbare Schaltausg" LCAE "nge" \
}


// Menu option: Frequency synthesizer.

#define DEFAULT_OPT_NAME_SYNTH  \
{                               \
  "Frequency Synthesizer",      \
  "Frequenz-Synthesizer"        \
}

#define DEFAULT_STR_SYNTH_FREQ  \
{                               \
  "Frequency",                  \
  "Frequenz"                    \
}

#define DEFAULT_STR_SYNTH_PHASE  \
{                                \
  "Phase",                       \
  NULL                           \
}


// Menu option: LAN interface.

#define DEFAULT_OPT_NAME_LAN_INTF_EN  "LAN Interface"
#define DEFAULT_OPT_NAME_LAN_INTF_DE  "Netzwerkschnittstelle"

#define DEFAULT_OPT_NAME_LAN_INTF  \
{                                  \
  DEFAULT_OPT_NAME_LAN_INTF_EN,    \
  DEFAULT_OPT_NAME_LAN_INTF_DE     \
}



// Menu option: PTP configuration.

#define DEFAULT_OPT_NAME_PTP_CFG_EN  "PTP Configuration"
#define DEFAULT_OPT_NAME_PTP_CFG_DE  "PTP-Konfiguration"

#define DEFAULT_OPT_NAME_PTP_CFG  \
{                                 \
  DEFAULT_OPT_NAME_PTP_CFG_EN,    \
  DEFAULT_OPT_NAME_PTP_CFG_DE     \
}



// Menu option: PTP unicast configuration.

#define DEFAULT_OPT_NAME_PTP_UC_CFG_EN  "PTP Unicast Configuration"
#define DEFAULT_OPT_NAME_PTP_UC_CFG_DE  "PTP-Unicast-Konfiguration"

#define DEFAULT_OPT_NAME_PTP_UC_CFG  \
{                                    \
  DEFAULT_OPT_NAME_PTP_UC_CFG_EN,    \
  DEFAULT_OPT_NAME_PTP_UC_CFG_DE     \
}



/*
 * Default initializers for German mode string names.
 * English strings are defined in in gpsdefs.h.
 */
#define GER_MODE_NAME_STR_ON_REQ       "nur auf Anfrage '?'"
#define GER_MODE_NAME_STR_PER_SEC      "sek" LCUE "ndlich"
#define GER_MODE_NAME_STR_PER_MIN      "min" LCUE "tlich"
#define GER_MODE_NAME_STR_AUTO         "automatisch"
#define GER_MODE_NAME_STR_ON_REQ_SEC   "sek" LCUE "ndlich nach Anfrage"

#define DEFAULT_MODE_NAMES                                       \
{                                                                \
  { ENG_MODE_NAME_STR_ON_REQ,     GER_MODE_NAME_STR_ON_REQ },    \
  { ENG_MODE_NAME_STR_PER_SEC,    GER_MODE_NAME_STR_PER_SEC },   \
  { ENG_MODE_NAME_STR_PER_MIN,    GER_MODE_NAME_STR_PER_MIN },   \
  { ENG_MODE_NAME_STR_AUTO,       GER_MODE_NAME_STR_AUTO },      \
  { ENG_MODE_NAME_STR_ON_REQ_SEC, GER_MODE_NAME_STR_ON_REQ_SEC } \
}


/*
 * Default initializers for German pulse output mode string names.
 * English strings are defined in in gpsdefs.h.
 */
#define GER_POUT_NAME_IDLE            "Nicht verwendet"
#define GER_POUT_NAME_TIMER           "Zeitschaltung"
#define GER_POUT_NAME_SINGLE_SHOT     "Einzelimpuls"
#define GER_POUT_NAME_CYCLIC_PULSE    "Zyklischer Impuls"
#define GER_POUT_NAME_PER_SEC         "Sek" LCUE "ndlicher Impuls"
#define GER_POUT_NAME_PER_MIN         "Min" LCUE "tlicher Impuls"
#define GER_POUT_NAME_PER_HOUR        "St" LCUE "ndlicher Impuls"
#define GER_POUT_NAME_DCF77           "DCF77-Zeitmarken"
#define GER_POUT_NAME_POS_OK          "Position OK"
#define GER_POUT_NAME_TIME_SYNC       "Zeit synchron"
#define GER_POUT_NAME_ALL_SYNC        "Alles synchron"
#define GER_POUT_NAME_TIMECODE        "DCLS-Zeitcode"
#define GER_POUT_NAME_TIMESTR         "Serielles Zeittelegramm"
#define GER_POUT_NAME_10MHZ           "Festfrequenz 10 MHz"
#define GER_POUT_NAME_DCF77_M59       "DCF77-Zeitmarken mit 59. Impuls"
#define GER_POUT_NAME_SYNTH           "Synthesizer-Frequenz"
#define GER_POUT_NAME_TIME_SLOTS      "Zeitschlitze pro Minute"
#define GER_POUT_NAME_GPIO            "GPIO-Signal"
#define GER_POUT_PTTI_PPS             "PTTI 1 PPS"
#define GER_POUT_HAVEQUICK            "HaveQuick"

#define DEFAULT_GER_POUT_NAMES \
{                              \
  GER_POUT_NAME_IDLE,          \
  GER_POUT_NAME_TIMER,         \
  GER_POUT_NAME_SINGLE_SHOT,   \
  GER_POUT_NAME_CYCLIC_PULSE,  \
  GER_POUT_NAME_PER_SEC,       \
  GER_POUT_NAME_PER_MIN,       \
  GER_POUT_NAME_PER_HOUR,      \
  GER_POUT_NAME_DCF77,         \
  GER_POUT_NAME_POS_OK,        \
  GER_POUT_NAME_TIME_SYNC,     \
  GER_POUT_NAME_ALL_SYNC,      \
  GER_POUT_NAME_TIMECODE,      \
  GER_POUT_NAME_TIMESTR,       \
  GER_POUT_NAME_10MHZ,         \
  GER_POUT_NAME_DCF77_M59,     \
  GER_POUT_NAME_SYNTH,         \
  GER_POUT_NAME_TIME_SLOTS,    \
  GER_POUT_NAME_GPIO,          \
  GER_POUT_PTTI_PPS,           \
  GER_POUT_HAVEQUICK           \
}

/*
 * Default initializers for German pulse output mode hints.
 * English strings are defined in in gpsdefs.h.
 */
#define GER_POUT_HINT_IDLE            "Konstanter Ausgangspegel"
#define GER_POUT_HINT_TIMER           "Schalten zu den angegebenen Zeiten"
#define GER_POUT_HINT_SINGLE_SHOT     "Einzelner Impuls mit angegebener L" LCAE "nge"
#define GER_POUT_HINT_CYCLIC_PULSE    "Impulse wiederholt nach angegebenem Intervall"
#define GER_POUT_HINT_PER_SEC         "Impuls zu Beginn jeder Sekunde"
#define GER_POUT_HINT_PER_MIN         "Impuls zu Beginn jeder Minute"
#define GER_POUT_HINT_PER_HOUR        "Impuls zu Beginn jeder Stunde"
#define GER_POUT_HINT_DCF77           "DCF77-kompatible Zeitmarken"
#define GER_POUT_HINT_POS_OK          "Schalten, wenn Empf" LCAE "ngerposition " LCUE "berpr" LCUE "ft"
#define GER_POUT_HINT_TIME_SYNC       "Schalten, wenn Zeit synchron"
#define GER_POUT_HINT_ALL_SYNC        "Schalten, wenn Zeit synchron und Position " LCUE "berpr" LCUE "ft"
#define GER_POUT_HINT_TIMECODE        "Unmodulierter Zeitcode des IRIG-Ausgangs"
#define GER_POUT_HINT_TIMESTR         "Zeittelegramm der seriellen Schnittstelle der Karte duplizieren"
#define GER_POUT_HINT_10MHZ           "Feste Ausgangsfrequenz 10 MHz"
#define GER_POUT_HINT_DCF77_M59       "Zeitmarken wie DCF77, aber mit 500 ms Impuls in 59. Sekunde"
#define GER_POUT_HINT_SYNTH           "Durch programmierbaren Synthesizer erzeugte Frequenz"
#define GER_POUT_HINT_TIME_SLOTS      "Programmierbare Zeitslots, die in jeder Minute aktiviert werden"
#define GER_POUT_HINT_GPIO            "Signal des spezifizierten GPIO-Ein- oder Ausgangs"
#define GER_POUT_HINT_PTTI_PPS        "20 us-Impuls zum Sekundenbeginn"
#define GER_POUT_HINT_HAVEQUICK       "Dupliziertes HaveQuick-Signal"

#define DEFAULT_GER_POUT_HINTS \
{                              \
  GER_POUT_HINT_IDLE,          \
  GER_POUT_HINT_TIMER,         \
  GER_POUT_HINT_SINGLE_SHOT,   \
  GER_POUT_HINT_CYCLIC_PULSE,  \
  GER_POUT_HINT_PER_SEC,       \
  GER_POUT_HINT_PER_MIN,       \
  GER_POUT_HINT_PER_HOUR,      \
  GER_POUT_HINT_DCF77,         \
  GER_POUT_HINT_POS_OK,        \
  GER_POUT_HINT_TIME_SYNC,     \
  GER_POUT_HINT_ALL_SYNC,      \
  GER_POUT_HINT_TIMECODE,      \
  GER_POUT_HINT_TIMESTR,       \
  GER_POUT_HINT_10MHZ,         \
  GER_POUT_HINT_DCF77_M59,     \
  GER_POUT_HINT_SYNTH,         \
  GER_POUT_HINT_TIME_SLOTS,    \
  GER_POUT_HINT_GPIO,          \
  GER_POUT_HINT_PTTI_PPS,      \
  GER_POUT_HINT_HAVEQUICK      \
}



// Some macros which generate proper function calls.

#define _pcps_snprint_vernum_dec( _s, _sz, _v ) \
  snprintf_safe( (_s), (_sz), "v%u.%02u",       \
                 ( (unsigned) (_v) ) / 100,     \
                 ( (unsigned) (_v) ) % 100 )

#define _pcps_snprint_vernum_hex( _s, _sz, _v ) \
  snprintf_safe( (_s), (_sz), "v%X.%02X",       \
           ( (unsigned) (_v) ) >> 8,            \
           ( (unsigned) (_v) ) & 0xFF )

#if defined( MBG_TGT_WIN32 )
  #define _pcps_snprint_vernum _pcps_snprint_vernum_dec
#else
  #define _pcps_snprint_vernum _pcps_snprint_vernum_hex
#endif


#define _pcps_snprint_dev_id( _s, _sz, _n ) \
  snprintf_safe( (_s), (_sz), "%04Xh", _n )


#define _pcps_snprint_wday( _s, _sz, _t, _l ) \
  snprint_ctry_wday( (_s), (_sz), _wday_mon17_to_sun06( (_t)->wday ), (_l) )

#define _pcps_snprint_date( _s, _sz, _t, _yl ) \
  snprint_ctry_dt( (_s), (_sz), (_t)->mday, (_t)->month, \
                   mbg_exp_year( (_t)->year, (_yl) ) )

#define _pcps_snprint_time( _s, _sz, _t ) \
  snprint_ctry_tm( (_s), (_sz), (_t)->hour, (_t)->min, (_t)->sec )

#define _pcps_snprint_time_long( _s, _sz, _t ) \
  snprint_ctry_tm_long( (_s), (_sz), (_t)->hour, (_t)->min, (_t)->sec, (_t)->sec100, 2 )


#define _cput_pcps_date( _t, _yl )                   \
{                                                    \
  char s[80];                                        \
  _pcps_snprint_date( s, sizeof( s ), (_t), (_yl) ); \
  cputs( s );                                        \
}

#define _cput_pcps_time( _t )                 \
{                                             \
  char s[80];                                 \
  _pcps_snprint_time( s, sizeof( s ), (_t) ); \
  cputs( s );                                 \
}

#define _cput_pcps_time_long( _t )                 \
{                                                  \
  char s[80];                                      \
  _pcps_snprint_time_long( s, sizeof( s ), (_t) ); \
  cputs( s );                                      \
}

#define _cput_pcps_date_and_time( _t, _yl, _tz )                     \
{                                                                    \
  char s[80];                                                        \
  cputs( pcps_date_time_str( s, sizeof( s ), (_t), (_yl), (_tz) ) ); \
}


_ext CLSTR lstr_cet
#ifdef _DO_INIT
  = { TZ_NAME_CET, TZ_NAME_MEZ }
#endif
;


_ext CLSTR lstr_cest
#ifdef _DO_INIT
  = { TZ_NAME_CEST, TZ_NAME_MESZ }
#endif
;

_ext CLSTR lstr_gmt
#ifdef _DO_INIT
  = { TZ_NAME_GMT, TZ_NAME_WEZ }
#endif
;


_ext CLSTR lstr_bst
#ifdef _DO_INIT
  = { TZ_NAME_BST, TZ_NAME_WESZ }
#endif
;

_ext CLSTR tzcode_name[N_PCPS_TZCODE]
#ifdef _DO_INIT
  = DEFAULT_TZCODE_NAMES
#endif
;


_ext int pcps_wday_date_dist
#ifdef _DO_INIT
  = DEFAULT_PCPS_WDAY_DATE_DIST
#endif
;


_ext int pcps_date_time_dist
#ifdef _DO_INIT
  = DEFAULT_PCPS_DATE_TIME_DIST
#endif
;


_ext int pcps_time_tz_dist
#ifdef _DO_INIT
  = DEFAULT_PCPS_TIME_TZ_DIST
#endif
;


_ext const char *mode_name[N_STR_MODE][N_LNG]
#ifdef _DO_INIT
 = DEFAULT_MODE_NAMES
#endif
;


_ext const char *short_mode_name[N_STR_MODE]
#ifdef _DO_INIT
 = DEFAULT_SHORT_MODE_NAMES
#endif
;


/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Return a language dependent string for "invalid".
 *
 * @return A language dependent string for "invalid"
 */
 const char *inv_str( void ) ;

 /**
 * @brief Determine a TZ name from a ::PCPS_TIME structure with status and %UTC offset.
 *
 * @param[in]  t       A ::PCPS_TIME structure read from a device.
 * @param[in]  flags   A combination of ::PCPS_TZ_NAME_FLAGS contolling the output string format.
 * @param[in]  is_msf  A Flag used to indicate if the is an MSF receiver.
 *
 * @return Pointer to a static string providing the determined name.
 *
 * @see ::pcps_tz_name_from_hr_time
 * @see ::pcps_tz_name_hr_status
 * @see ::pcps_tz_name_from_status
 * @see ::get_tz_name
 * @see ::PCPS_TZ_NAME_FLAGS
 */
 const char *pcps_tz_name( const PCPS_TIME *t, ulong flags, int is_msf ) ;

 /**
 * @brief Determine a TZ name from a ::PCPS_HR_TIME structure with status and %UTC offset.
 *
 * @param[in]  hrt     A ::PCPS_HR_TIME structure read from a device.
 * @param[in]  flags   A combination of ::PCPS_TZ_NAME_FLAGS contolling the output string format.
 * @param[in]  is_msf  A Flag used to indicate if the is an MSF receiver.
 *
 * @return Pointer to a static string providing the determined name.
 *
 * @see ::pcps_tz_name
 * @see ::pcps_tz_name_hr_status
 * @see ::pcps_tz_name_from_status
 * @see ::get_tz_name
 * @see ::PCPS_TZ_NAME_FLAGS
 */
 const char *pcps_tz_name_from_hr_time( const PCPS_HR_TIME *hrt, ushort flags, int is_msf ) ;

 /**
 * @brief Determine a TZ name from a ::PCPS_HR_TIME structure with time scale status and %UTC offset.
 *
 * Can be used to determine a name for the time zone if all of the timescale,
 * the %UTC/DST status, and the %UTC offset are known, e.g. from plug-in devices.
 *
 * @param[in]  t       A ::PCPS_HR_TIME structure read from a device.
 * @param[in]  flags   A combination of ::PCPS_TZ_NAME_FLAGS contolling the output string format.
 * @param[in]  is_msf  A Flag used to indicate if the is an MSF receiver.
 *
 * @return Pointer to a static string providing the determined name.
 *
 * @see ::pcps_tz_name
 * @see ::pcps_tz_name_from_hr_time
 * @see ::pcps_tz_name_from_status
 * @see ::get_tz_name
 * @see ::PCPS_TZ_NAME_FLAGS
 */
 const char *pcps_tz_name_hr_status( const PCPS_HR_TIME *t, ushort flags, int is_msf ) ;

 /**
 * @brief Determine a simple TZ name only from the clock status in ::PCPS_TIME_STATUS_X format.
 *
 * This function can be used to build a name for the time zone
 * if only the %UTC/DST status is known, but the %UTC offset is not.
 * This is the case, for example, if the Meinberg standard time string is decoded.
 *
 * @param[in]  status  Clock status in ::PCPS_TIME_STATUS_X format.
 *
 * @return Pointer to a static string providing the determined name.
 *
 * @see ::pcps_tz_name
 * @see ::pcps_tz_name_from_hr_time
 * @see ::pcps_tz_name_hr_status
 * @see ::get_tz_name
 * @see ::PCPS_TZ_NAME_FLAGS
 */
 const char *pcps_tz_name_from_status( PCPS_TIME_STATUS_X status ) ;

 char *pcps_date_time_str( char *s, size_t max_len, const PCPS_TIME *t, int year_limit, const char *tz_str ) ;
 int pcps_str_tm_gps_date_time( char *s, size_t max_len, const TM_GPS *t ) ;
 wchar_t *pcps_date_time_wstr( wchar_t *ws, size_t count, const PCPS_TIME *t, ushort year_limit, const wchar_t *tz_str ) ;
 /**
 * @brief Set up a set of device status strings.
 *
 * The strings depend on the status codes and the device type.
 *
 * @param[in]   status          Extended status code, see ::PCPS_TIME_STATUS_X.
 * @param[in]   status_is_read  Flag indicating if the @p status has actually been read.
 * @param[in]   is_gps          Flag indicating if the status has been read from a GPS receiver.
 * @param[out]  pstrs           Array of strings to be set up.
 */
 void pcps_status_strs( PCPS_TIME_STATUS_X status, int status_is_read, int is_gps, PCPS_STATUS_STRS *pstrs ) ;

 char *pcps_port_str( char *s, size_t max_len, const PCPS_DEV *pdev ) ;
 const char *pcps_tzcode_str( PCPS_TZCODE tzcode ) ;
 char *pcps_serial_str( char *s, size_t max_len, int i, const RECEIVER_PORT_CFG *p, const RECEIVER_INFO *p_ri, int short_strs ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif

/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _PCPSLSTR_H */

