
/**************************************************************************
 *
 *  $Id: mbgcfg_util.h 1.3.1.1 2025/11/19 09:35:15Z martin.burnicki REL_M $
 *
 *  Definitions and prototypes for mbgcfg_util.c.
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 * -----------------------------------------------------------------------
 *  $Log: mbgcfg_util.h $
 *  Revision 1.3.1.1  2025/11/19 09:35:15Z  martin.burnicki
 *  Moved definition of MBG_ERR_MSG_FNC to mbgerror.h.
 *  Revision 1.3  2025/07/25 14:48:16Z  martin.burnicki
 *  New definition MBGCFG_HELP_FP controls where usage output should go.
 *  Revision 1.2  2025/07/25 13:21:04Z  martin.burnicki
 *  New  CTRL_FLAGS mask CTRL_OMIT_FINAL_NEWLINE.
 *  Revision 1.1  2025/07/10 14:50:36Z  martin.burnicki
 *  Initial revision with code from mbgtools-lx/mbgctrl.
 *
 **************************************************************************/

#ifndef _MBGCFG_UTIL_H
#define _MBGCFG_UTIL_H


/* Other headers to be included */

#include <mbgversion.h>

#include <gpsdefs.h>
#include <mbgerror.h>

#include <stdio.h>
#include <string.h>


#if !defined( DEBUG_OPTIONS )
  #define DEBUG_OPTIONS  0
#endif

#if !defined( SUPP_MBGDEVIO )
  #define SUPP_MBGDEVIO  0
#endif

#if !defined( SUPP_MBGEXTIO )
  #define SUPP_MBGEXTIO  0
#endif


#if SUPP_MBGDEVIO
  #include <deviohlp.h>
  // #include <mbgctrl.h>  // FIXME remove
#else
  // Dummy declarations to avoid build errors
  // from function prototypes.
  typedef int MBG_DEV_HANDLE;
  typedef int OPT_HANDLERS_BUS;
#endif

#if SUPP_MBGEXTIO
  #include <extiohlp.h>
#else
  // Dummy declarations to avoid build errors
  // from function prototypes.
  typedef int MBG_EXT_HANDLE;
  typedef int MBGCFG_OPT_HANDLER_EXT;
#endif


#ifdef _MBGCFG_UTIL
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif


typedef const char *(STR_FNC)( int idx );


#define MBGCFG_HELP_FP stderr


_ext const char mbgcfg_str_empty[]
#ifdef _DO_INIT
 = ""
#endif
;



#if SUPP_MBGDEVIO

typedef struct
{
  RECEIVER_INFO ri;
  RECEIVER_PORT_CFG rpcfg;
} EXT_DEV_INFO;

_ext EXT_DEV_INFO glb_xdi;

#endif



typedef struct
{
  int left_marg;
  int indent_2;
  int indent_3;
  int indent_note;
  int comm_col_x;
} INDENTS;

#define INDENT_LEFT   2
#define INDENT_NOTE   4
#define INDENT_COL_X  30

_ext const INDENTS indents_2_4
#ifdef _DO_INIT
 = { INDENT_LEFT, 4, 6, INDENT_NOTE, INDENT_COL_X }
#endif
;

_ext const INDENTS indents_2_19
#ifdef _DO_INIT
 = { INDENT_LEFT, 19, 0, INDENT_NOTE, INDENT_COL_X }
#endif
;

_ext const INDENTS indents_2_24
#ifdef _DO_INIT
 = { INDENT_LEFT, 24, 0 , INDENT_NOTE, INDENT_COL_X }
#endif
;

_ext const INDENTS indents_2_33
#ifdef _DO_INIT
 = { INDENT_LEFT, 33, 0, INDENT_NOTE, INDENT_COL_X }
#endif
;

_ext const INDENTS indents_2_39
#ifdef _DO_INIT
 = { INDENT_LEFT, 39, 0, INDENT_NOTE, INDENT_COL_X }
#endif
;

_ext const INDENTS indents_2_45
#ifdef _DO_INIT
 = { INDENT_LEFT, 45, 0, INDENT_NOTE, INDENT_COL_X }
#endif
;


#if 1    // FIXME TODO deprecated!

#define SHOW_INDENT_1   "  "
#define SHOW_INDENT_2   "    "

#endif


_ext const INDENTS usage_indents_detailed
#ifdef _DO_INIT
 = { 4, 6, 8, 30 }
#endif
;


// TODO This shouldn't be required.
_ext const INDENTS *p_ind_detailed
#ifdef _DO_INIT
 = &usage_indents_detailed
#endif
;


_ext const INDENTS show_indents
#ifdef _DO_INIT
 = { 2, 4, 0, 0 }
#endif
;


// FIXME str_current_spc
_ext const char str_current[]
#ifdef _DO_INIT
 = "Current "
#endif
;

// FIXME str_new_spc
_ext const char str_new[]
#ifdef _DO_INIT
 = "New "
#endif
;

_ext const char str_truncated[]
#ifdef _DO_INIT
 = "truncated"
#endif
;

_ext const char str_not_accepted[]
#ifdef _DO_INIT
 = "not accepted"
#endif
;


typedef struct
{
  const char *cmd_name;
  const char *cmd_info;
  const char *not_supp_msg;
  uint32_t opt_flags;              ///< See ::OPT_FLAG_MASKS.

} MBGCFG_OPT_INFO;



enum OPT_FLAG_BITS
{
  OPT_FLAG_CMD_IDX_BIT,        ///< Command with index, e.g., COM0=, COM1=, etc. vs. TZ=.
  OPT_FLAG_NO_PARA_SPACE_BIT,  ///< Don't print a space after this paragraph
  N_OPT_FLAG_BITS
};


enum OPT_FLAG_MASKS
{
  OPT_FLAG_CMD_IDX       = ( 1UL << OPT_FLAG_CMD_IDX_BIT ),       ///< See ::OPT_FLAG_CMD_IDX_BIT.
  OPT_FLAG_NO_PARA_SPACE = ( 1UL << OPT_FLAG_NO_PARA_SPACE_BIT )  ///< See ::OPT_FLAG_NO_PARA_SPACE_BIT.
};



/**
 * @brief A type used to pass print control flags to functions.
 *
 * @see ::CTRL_FLAG_MASKS
 */
typedef int CTRL_FLAGS;


/**
 * @brief Flag masks used with ::CTRL_FLAGS.
 *
 * @see ::CTRL_FLAGS
 */
enum CTRL_FLAG_MASKS
{
  CTRL_PRINT_ALL = 0x0001,          ///< Print all known values as opposed to only supported values.
  CTRL_PRINT_NEWLINES = 0x0002,     ///< Print newline after each entry
  CTRL_PRINT_IDX = 0x0004,          ///< Print index numbers before entries.
  CTRL_PRINT_ERR = 0x0008,
  CTRL_PRINT_PLUS = 0x0010,         ///< Print '+' character as supposed to commas between values.
  CTRL_NOT_SUPP = 0x0020,
  CTRL_OMIT_FINAL_NEWLINE = 0x0040  ///< Don't print a final newline after an enumeration.
};



#if SUPP_MBGDEVIO

typedef struct OPT_HANDLERS_BUS_S OPT_HANDLERS_BUS;

typedef int MBGCFG_HELP_FNC_BUS( MBG_DEV_HANDLE, const MBGCFG_OPT_INFO *, CTRL_FLAGS );
typedef int MBGCFG_EVAL_FNC_BUS( MBG_DEV_HANDLE, const char *, int );
typedef int MBGCFG_SHOW_FNC_BUS( MBG_DEV_HANDLE, const MBGCFG_OPT_INFO *, const char * );


typedef struct
{
  const MBGCFG_OPT_INFO *opt_info;
  MBG_CHK_SUPP_FNC *chk_supp_fnc;
  MBGCFG_HELP_FNC_BUS *help_fnc;
  MBGCFG_EVAL_FNC_BUS *eval_fnc;
  MBGCFG_SHOW_FNC_BUS *show_fnc;

} MBGCFG_OPT_HANDLER_BUS;

#endif  // SUPP_MBGDEVIO



#if SUPP_MBGEXTIO

typedef struct
{
  MBG_MSG_CTL *pmctl;
  const XBP_ADDR *p_addr;

} MBG_EXT_HANDLE;


typedef int MBGCFG_HELP_FNC_EXT( MBG_EXT_HANDLE *, const MBGCFG_OPT_INFO *, CTRL_FLAGS );
typedef int MBGCFG_EVAL_FNC_EXT( MBG_EXT_HANDLE *, const char *, int );
typedef int MBGCFG_SHOW_FNC_EXT( MBG_EXT_HANDLE *, const MBGCFG_OPT_INFO *, const char * );


typedef struct
{
  const MBGCFG_OPT_INFO *opt_info;
  MBGEXTIO_CHK_SUPP_FNC *chk_supp_fnc;
  MBGCFG_HELP_FNC_EXT *help_fnc;
  MBGCFG_EVAL_FNC_EXT *eval_fnc;
  MBGCFG_SHOW_FNC_EXT *show_fnc;

} MBGCFG_OPT_HANDLER_EXT;

#endif  // SUPP_MBGEXTIO



/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 int snprintf_spaces( char *s, size_t max_len, int n_spaces ) ;
 /**
 * @brief Print a specific error message.
 *
 * @param[in] info   Message info to be printed
 *
 * @return Always ::MBG_SUCCESS
 */
 int err_msg( const char *info ) ;

 long check_range( long l, long min_limit, long max_limit ) ;
 /**
 * @brief Print a formatted list of options defined by a bit mask.
 *
 * @param[in]  fp          Fhe @a FILE to which to print, e.g. stdout or stderr.
*
 * @param[in]  info_1      Optional string specifying the kind of information, may be @a NULL.
 * @param[in]  info_2      Optional string with extended information, may be @a NULL.
 *
 * @param[in]  supp_mask   Bit mask of supported options from the option list.
 *                         If @ref CTRL_PRINT_ALL is set in @p ctrl_flags, the original
 *                         value of @p supp_mask is ignored, and the mask is extended
 *                         to support all @p n_known options.
 *
 * @param[in]  n_known     Number of known values in the option list.
 *
 * @param[in]  names       Table of option names with at least @p n_known entries, may be @a NULL.
 *                         If no table is provided, @p s_func is called instead, if specified.
 *
 * @param[in]  s_fnc       Optional function that retrieves a string, may be @a NULL.
 * @param[in]  inst_idx    Parameter for the optional function specified in @p s_fnc.
 *
 * @param[in]  ctrl_flags  Flags controlling output formatting, see ::CTRL_FLAGS.
 * @param[in]  p_ind       Optional indents used for output formatting, may be @a NULL.
 */
 void print_bit_mask_list( FILE *fp, const char *info_1, const char *info_2, uint32_t supp_mask, int n_known, const char * const names[], STR_FNC *s_fnc, int inst_idx, CTRL_FLAGS ctrl_flags, const INDENTS *p_ind ) ;

 /**
 * @brief Check if parameter string starts with a particular keyword.
 *
 * @param[in]  s        The parameter string to check.
 * @param[in]  keyword  The keyword to be looked for.
 *
 * @return Pointer to the first character @a after the keyword in @p s,
 *         if the exact @p keyword was found in @p s, else @a NULL.
 */
 const char *str_parm_p( const char *s, const char *keyword ) ;

 void usage_newline( void ) ;
 __attribute__( ( format( printf, 4, 5 ) ) ) int usage_line( const INDENTS *p_ind, const MBGCFG_OPT_INFO *p_oi, const char *cmd_parm, const char *cmd_comment_fmt, ... ) ;
 int print_indent( FILE *fp, int i ) ;
 void usage_line_where( const INDENTS *p_ind ) ;
 __attribute__( ( format( printf, 2, 3 ) ) ) int usage_note( int indent, const char *fmt, ... ) ;

/* ----- function prototypes end ----- */


#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _MBGCFG_UTIL_H */

