
/**************************************************************************
 *
 *  $Id: mbg_prog_info.h 1.1 2025/07/10 14:50:04Z martin.burnicki REL_M $
 *
 *  Definitions and prototypes for mbg_prog_info.c.
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 * -----------------------------------------------------------------------
 *  $Log: mbg_prog_info.h $
 *  Revision 1.1  2025/07/10 14:50:04Z  martin.burnicki
 *  Initial revision with code from toolutil.c/.h.
 *
 **************************************************************************/

#ifndef _MBG_PROG_INFO_H
#define _MBG_PROG_INFO_H


/* Other headers to be included */

#include <mbgversion.h>


#ifdef _MBG_PROG_INFO
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif


/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Make stdout unbuffered.
 *
 * If the output has been redirected, make stdout unbuffered, e.g.
 * to see the output immediately even though piped through 'tee'.
 */
 void mbg_make_stdout_unbuffered( void ) ;

 /**
 * @brief Print the program version to a string buffer.
 *
 * @param[out]  s        Address of a string buffer to be filled.
 * @param[in]   max_len  Size of the string buffer.
 *
 * @return The number of characters written to the string buffer,
 *         except the terminating 0.
 */
 int mbg_program_version_str( char *s, size_t max_len ) ;

 /**
 * @brief Print some program info to a string buffer.
 *
 * @param[out]  s           Address of a string buffer to be filled.
 * @param[in]   max_len     Size of the string buffer.
 * @param[in]   pname       The program name.
 * @param[in]   first_year  First copyright year.
 * @param[in]   last_year   Last copyright year.
 *
 * @return The number of characters written to the string buffer,
 *         except the terminating 0.
 */
 int mbg_program_info_str( char *s, size_t max_len, const char *pname, int first_year, int last_year ) ;

 /**
 * @brief Print program info to console.
 *
 * @param[in]  pname       The program name.
 * @param[in]  first_year  First copyright year.
 * @param[in]  last_year   Last copyright year.
 */
 void mbg_print_program_info( const char *pname, int first_year, int last_year ) ;


/* ----- function prototypes end ----- */


#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _MBG_PROG_INFO_H */

