
/**************************************************************************
 *
 *  $Id: rsrc_bsd.h 1.4 2020/09/30 15:20:49Z martin.burnicki REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for rsrc_bsd.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: rsrc_bsd.h $
 *  Revision 1.4  2020/09/30 15:20:49Z  martin.burnicki
 *  Updated function prototypes.
 *  Revision 1.3  2018/06/13 15:39:04  martin
 *  Updated function prototypes.
 *  Revision 1.2  2012/11/07 10:24:10  martin
 *  Removed obsolete include.
 *  Revision 1.1  2011/01/26 16:09:34  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _RSRC_BSD_H
#define _RSRC_BSD_H


/* Other headers to be included */

#include <rsrc.h>
#include <mbggenio.h>
#include <words.h>

#ifdef _RSRC_BSD
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif


/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Try to allocate an I/O port resource range
 *
 * @param[in] port          First port address to allocate
 * @param[in] n             Number of port addresses to allocate
 *
 * @return ::MBG_SUCCESS if the port range could be allocated, else ::MBG_ERR_CLAIM_RSRC
 */
 int rsrc_alloc_ports( ulong port, ulong n ) ;

 /**
 * @brief Release an I/O port resource range which has been allocated before
 *
 * @param[in] port          First port address to release
 * @param[in] n             Number of port addresses to release
 */
 void rsrc_dealloc_ports( ulong port, ulong n ) ;

 /**
 * @brief Try to allocate a memory resource range
 *
 * @param[in] start  First port address to allocate
 * @param[in] len    Number of port addresses to allocate
 *
 * @return ::MBG_SUCCESS if the port range could be allocated, else ::MBG_ERR_CLAIM_RSRC
 */
 int rsrc_alloc_mem( MBG_IOMEM_ADDR_RAW start, ulong len ) ;

 /**
 * @brief Release a memory resource range which has been allocated before
 *
 * @param[in] start  First port address to release
 * @param[in] len    Number of port addresses to release
 */
 void rsrc_dealloc_mem( MBG_IOMEM_ADDR_RAW start, ulong len ) ;


/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext

#endif  /* _RSRC_BSD_H */
