
/**************************************************************************
 *
 *  $Id: rsrc_bsd.c 1.4 2020/09/30 15:23:13Z martin.burnicki REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Interface functions for the Linux resource manager.
 *
 * -----------------------------------------------------------------------
 *  $Log: rsrc_bsd.c $
 *  Revision 1.4  2020/09/30 15:23:13Z  martin.burnicki
 *  Fixed a compiler warning on NetBSD.
 *  Revision 1.3  2018/06/13 15:37:58  martin
 *  Cleanup and doxygen comments.
 *  Revision 1.2  2017/07/06 09:05:19  martin
 *  Removed obsolete code.
 *  Cleanup.
 *  Revision 1.1  2011/01/26 16:09:33  martin
 *  Initial revision.
 *
 **************************************************************************/

#define _RSRC_BSD
 #include <rsrc_bsd.h>
#undef _RSRC_BSD

#include <mbgerror.h>
#include <mbgddmsg.h>



/*HDR*/
/**
 * @brief Try to allocate an I/O port resource range
 *
 * @param[in] port          First port address to allocate
 * @param[in] n             Number of port addresses to allocate
 *
 * @return ::MBG_SUCCESS if the port range could be allocated, else ::MBG_ERR_CLAIM_RSRC
 */
int rsrc_alloc_ports( ulong port, ulong n )
{
  // Nothing to do; just avoid "unused variable" warnings
  (void) port;
  (void) n;

  #if DEBUG_RSRC
    _mbg_kdd_msg_2( MBG_LOG_DEBUG, "Requested I/O region: %03lX (%lu)", port, n );
  #endif

  return MBG_SUCCESS;

}  // rsrc_alloc_ports



/*HDR*/
/**
 * @brief Release an I/O port resource range which has been allocated before
 *
 * @param[in] port          First port address to release
 * @param[in] n             Number of port addresses to release
 */
void rsrc_dealloc_ports( ulong port, ulong n )
{
  // Nothing to do; just avoid "unused variable" warnings
  (void) port;
  (void) n;

  #if DEBUG_RSRC
    _mbg_kdd_msg_2( MBG_LOG_DEBUG, "Released I/O region: %03lX (%lu)", port, n );
  #endif

}  // rsrc_dealloc_ports



/*HDR*/
/**
 * @brief Try to allocate a memory resource range
 *
 * @param[in] start  First port address to allocate
 * @param[in] len    Number of port addresses to allocate
 *
 * @return ::MBG_SUCCESS if the port range could be allocated, else ::MBG_ERR_CLAIM_RSRC
 */
int rsrc_alloc_mem( MBG_IOMEM_ADDR_RAW start, ulong len )
{
  // Nothing to do; just avoid "unused variable" warnings
  (void) start;
  (void) len;

  #if DEBUG_RSRC
    _mbg_kdd_msg_2( MBG_LOG_DEBUG, "Requested mem region: %llX (%lu)",
                    (unsigned long long) start, len );
  #endif

  return MBG_SUCCESS;

}  // rsrc_alloc_mem



/*HDR*/
/**
 * @brief Release a memory resource range which has been allocated before
 *
 * @param[in] start  First port address to release
 * @param[in] len    Number of port addresses to release
 */
void rsrc_dealloc_mem( MBG_IOMEM_ADDR_RAW start, ulong len )
{
  // Nothing to do; just avoid "unused variable" warnings
  (void) start;
  (void) len;

  #if DEBUG_RSRC
    _mbg_kdd_msg_2( MBG_LOG_DEBUG, "Released mem region: %llX (%lu)",
                    (unsigned long long) start, len );
  #endif

}  // rsrc_dealloc_mem




