
/**************************************************************************
 *
 *  $Id: pci_bsd.h 1.2 2012/11/07 10:23:46Z martin REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions to enable usage of Meinberg PCI function calls
 *    with *BSD.
 *
 * -----------------------------------------------------------------------
 *  $Log: pci_bsd.h $
 *  Revision 1.2  2012/11/07 10:23:46Z  martin
 *  Cleanup.
 *  Revision 1.1  2011/01/26 16:09:33  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _PCI_BSD_H
#define _PCI_BSD_H


/* Other headers to be included */

#include <pcidefs.h>


#ifdef _PCI_BSD
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

#define _mbg_pci_find_bios( _p1, _p2, _p3 )  \
  ( pcibios_present() ? PCI_SUCCESS : PCI_NO_SUCCESS )

#define _mbg_pci_find_device( _did, _vid, _ix, _pbn, _pdfn )  \
  pcibios_find_device( (_vid), (_did), (_ix), (_pbn), (_pdfn) )

#define _mbg_pci_read_cfg_byte    pcibios_read_config_byte
#define _mbg_pci_read_cfg_word    pcibios_read_config_word
#define _mbg_pci_read_cfg_dword   pcibios_read_config_dword

#define _mbg_pci_write_cfg_byte   pcibios_write_config_byte
#define _mbg_pci_write_cfg_word   pcibios_write_config_word
#define _mbg_pci_write_cfg_dword  pcibios_write_config_dword

/* End of header body */

#undef _ext

#endif  /* _PCI_BSD_H */
