
/**************************************************************************
 *
 *  $Id: words.h 1.11.1.1 2004/11/11 10:40:15Z gregoire TRASH $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions of commonly used data types.
 *
 * -----------------------------------------------------------------------
 *  $Log: words.h $
 *  Revision 1.11.1.1  2004/11/11 10:40:15Z  gregoire
 *  Revision 1.11  2004/11/10 10:45:34Z  martin
 *  Added C99 fixed-type handling for QNX.
 *  Revision 1.10  2004/11/09 13:12:56  martin
 *  Redefined C99 integer types with fixed sizes as standard types
 *  if required, depending on the environment.
 *  Revision 1.9  2003/02/07 11:36:54  MARTIN
 *  New macros _hilo_16() and _hilo_32() for endian conversion.
 *  Revision 1.8  2002/05/28 10:09:54  MARTIN
 *  Added new macros _var_bswap16() and _var_bswap32().
 *  Revision 1.7  2001/03/14 11:30:48  MARTIN
 *  Removed definitions for UINT8, UINT16, UINT32.
 *  Redefined preprocessor control for Win32.
 *  Revision 1.6  2001/02/28 15:43:20  MARTIN
 *  Modified preprocessor syntax.
 *  Revision 1.5  2001/02/05 10:20:53  MARTIN
 *  Include different Linux types for user space and kernel space programs.
 *  Source code cleanup.
 *  Revision 1.4  2000/09/15 08:34:11  MARTIN
 *  Exclude some definitions if compiling under Win NT.
 *  Revision 1.3  2000/08/22 15:04:28  MARTIN
 *  Added new file header.
 *  Added macros to revert endianess of 16 and 32 bit values.
 *
 **************************************************************************/

#ifndef _WORDS_H
#define _WORDS_H


/* Other headers to be included */

#ifdef _WORDS
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

// Depending on the target environment, configure whether
// C99 fixed-size types are supported, or not.
// If they are not defined, they have to be defined using
// standard data types of appropriate size.

#if defined( __linux )       // any Linux target

  #if defined( __KERNEL__ )
    #include <linux/types.h>
    #define _C99_BIT_TYPES_DEFINED          1
  #else
    #include <sys/types.h>
    #define _C99_PSEUDO_BIT_TYPES_DEFINED   1
  #endif
  
#elif defined( __QNX__ )     // target QNX 4 or QNX 6

  #if defined( __QNXNTO__ )  // target QNX 6 (Neutrino)
    #include <stdint.h>
  #else                      // QNX 4.25
    #include <inttypes.h>    
  #endif
  
  #define _C99_BIT_TYPES_DEFINED          1
  
#endif


typedef unsigned char uchar;

#if !defined( __linux )
  typedef unsigned short ushort;
  typedef unsigned int uint;
  typedef unsigned long ulong;
#endif

typedef double udouble;

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long longword;
typedef unsigned long dword;



#if !defined( _C99_BIT_TYPES_DEFINED )
  #if defined( _C99_PSEUDO_BIT_TYPES_DEFINED )
    // While the C99 standard requires names like uint8_t for unsigned integer 
    // types with a fixed number of bits, some implementations define types 
    // like u_int8_t instead, but not the required names. This is fixed here.
    // Normally, the signed types have been properly defined in this case.
    typedef u_int8_t  uint8_t;
    typedef u_int16_t uint16_t;
    typedef u_int32_t uint32_t;
    typedef u_int64_t uint64_t;
  #else
    // The lines below define some C99 types based on standard types with
    // the proper sizes commonly used in 16/32 bit environments.
    // The 64 bit types have not yet been used.
    typedef char           int8_t;
    typedef unsigned char  uint8_t;
    
    typedef short          int16_t;
    typedef unsigned short uint16_t;
    
    typedef long           int32_t;
    typedef unsigned long  uint32_t;

    #if defined( _WIN32 ) || defined( __WIN32__ )
      #include <windows.h>
      typedef LONGLONG int64_t;
    #endif
  
    #if defined( __WATCOMC__ ) && ( __WATCOMC__ >= 1100 )
      typedef __int64      int64_t;
    #endif

  #endif
#endif



// a macro to swap the byte order of a 16 bit value
#define _bswap16( _x )                      \
(                                           \
  ( ( ( (ushort) (_x) ) & 0x00FF ) << 8 ) | \
  ( ( ( (ushort) (_x) ) & 0xFF00 ) >> 8 )   \
)

// a macro to swap the byte order of a 32 bit value
#define _bswap32( _x )                            \
(                                                 \
  ( ( ( (ulong) (_x) ) & 0x000000FFUL ) << 24 ) | \
  ( ( ( (ulong) (_x) ) & 0x0000FF00UL ) << 8 )  | \
  ( ( ( (ulong) (_x) ) & 0x00FF0000UL ) >> 8 )  | \
  ( ( ( (ulong) (_x) ) & 0xFF000000UL ) >> 24 )   \
)

#define _var_bswap16( _v )   (_v) = _bswap16( _v )
#define _var_bswap32( _v )   (_v) = _bswap32( _v )


// The C51 compiler is big-endian, that means the most
// significant byte of a 16 or 32 bit value is stored in
// the lowest memory location. Most other systems are
// little-endian, so we must use macros to adjust the
// byte order if the C51 is used.

#if defined _CC51
  #define _hilo_16( _x )  _bswap16( _x )
  #define _hilo_32( _x )  _bswap32( _x )
#else
  #define _hilo_16( _x )  (_x)
  #define _hilo_32( _x )  (_x)
#endif

/* End of header body */

#undef _ext

#endif  /* _WORDS_H */
