
/**************************************************************************
 *
 *  $Id: pcpsutil.h 1.9 2004/11/09 14:30:50Z martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for pcpsutil.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: pcpsutil.h $
 *  Revision 1.9  2004/11/09 14:30:50Z  martin
 *  Redefined interface data types using C99 fixed-size definitions.
 *  Updated function prototypes.
 *  Revision 1.8  2004/04/14 09:22:09Z  martin
 *  Pack structures 1 byte aligned.
 *  Revision 1.7  2001/11/28 14:41:25Z  MARTIN
 *  Changed PCPS_HRT_FRAC_SCALE and PCPS_HRT_FRAC_SCALE_FMT
 *  to print 7 rather than 6 digits.
 *  Revision 1.6  2001/09/14 11:59:33  MARTIN
 *  Support for PCPS_HR_TIME fraction conversion.
 *  Updated function prototypes.
 *  Revision 1.5  2001/08/14 12:06:44  MARTIN
 *  Defined constants used to draw a signal bar
 *  depending on a DCF77 clock's signal value.
 *  Revision 1.4  2001/03/01 14:03:18  MARTIN
 *  Updated function prototypes.
 *  Revision 1.3  2000/08/31 14:06:05  MARTIN
 *  Updated function prototypes.
 *  Revision 1.2  2000/07/21 13:43:40  MARTIN
 *  Initial revision
 *
 **************************************************************************/

#ifndef _PCPSUTIL_H
#define _PCPSUTIL_H


/* Other headers to be included */

#include <pcpsdefs.h>
#include <use_pack.h>


#ifdef _PCPSUTIL
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

#if defined( _USE_PACK )      // set byte alignment
  #pragma pack( 1 )
#endif


// The following constants are used to draw a signal bar
// depending on a DCF77 clock's signal value:
#define PCPS_SIG_BIAS 55
#define PCPS_SIG_ERR  1
#define PCPS_SIG_MIN  20
#define PCPS_SIG_MAX  68


// The scale and format to be used to print the fractions
// of a second as returned in the PCPS_HR_TIME structure.
// The function frac_sec_from_bin() can be used for
// the conversion.
#ifndef PCPS_HRT_FRAC_SCALE
  #define PCPS_HRT_FRAC_SCALE       10000000UL
#endif

#ifndef PCPS_HRT_FRAC_SCALE_FMT
  #define PCPS_HRT_FRAC_SCALE_FMT   "%07lu"
#endif



// the structure below is used with a DCF77 clock's serial interface
typedef struct
{
  PCPS_SERIAL pack; // this byte is passed to the board as parameter

  uint8_t baud;     // the other bytes can hold the unpacked values
  uint8_t frame;
  uint8_t mode;

} PCPS_SER_PACK;



/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 uint32_t frac_sec_from_bin( uint32_t b, uint32_t scale ) ;
 uint16_t pcps_exp_year( uint8_t year, uint16_t year_lim ) ;
 void pcps_setup_isa_ports( char *s, uint16_t *port_vals, int n_vals ) ;
 void pcps_unpack_serial( PCPS_SER_PACK *p ) ;
 void pcps_pack_serial( PCPS_SER_PACK *p ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


#if defined( _USE_PACK )   // set default alignment
  #pragma pack()
#endif

/* End of header body */

#undef _ext


#endif  /* _PCPSUTIL_H */
