
/**************************************************************************
 *
 *  $Id: mbgdevio.h 1.14.1.1 2005/01/10 14:46:13Z martin TRASH $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions used with with Meinberg driver device I/O.
 *
 * -----------------------------------------------------------------------
 *  $Log: mbgdevio.h $
 *  Revision 1.14.1.1  2005/01/10 14:46:13Z  martin
 *  Updated function prototypes.
 *  Revision 1.14  2004/12/09 11:24:00Z  martin
 *  Support configuration of on-board frequency synthesizer.
 *  Revision 1.13  2004/11/09 14:13:00Z  martin
 *  Updated function prototypes.
 *  Revision 1.12  2004/08/17 11:13:46Z  martin
 *  Account for renamed symbols.
 *  Revision 1.11  2004/04/14 09:34:23Z  martin
 *  New definition MBGDEVIO_COMPAT_VERSION.
 *  Pack structures 1 byte aligned.
 *  Revision 1.10  2003/12/22 15:35:10Z  martin
 *  New revision 2.03.
 *  Moved some definitions to pcpsdev.h.
 *  New structures to read device time together with associated
 *  PC high resolution timer cycles.
 *  Updated function prototypes.
 *  Revision 1.9  2003/06/19 08:50:05Z  martin
 *  Definition of MBGDEVIO_VERSION number to allow DLL 
 *  API version checking.
 *  Replaced some defines by typedefs.
 *  Renamed USE_DOS_TSR to MBG_USE_DOS_TSR.
 *  New preprocessor symbol MBG_USE_KERNEL_DRIVER which 
 *  is defined only for targets which use IOCTLs.
 *  Don't include pcps_dos.h here.
 *  Updated function prototypes.
 *  Revision 1.8  2003/05/16 08:44:26  MARTIN
 *  Cleaned up inclusion of headers.
 *  Removed obsolete definitions.
 *  Changes for direct access targets.
 *  Revision 1.7  2003/04/25 10:16:00  martin
 *  Updated inclusion of headers.
 *  Made prototypes available for all targets.
 *  Revision 1.6  2003/04/15 19:38:05Z  martin
 *  Updated function prototypes.
 *  Revision 1.5  2003/04/09 13:44:53Z  martin
 *  Use new common IOCTL codes from mbgioctl.h.
 *  Updated function prototypes.
 *  Revision 1.4  2002/09/06 11:06:35Z  martin
 *  Updated function prototypes for Win32 API..
 *  Win32 compatibility macros to use old APIs with new functions.
 *  Support targets OS/2 and NetWare.
 *  Revision 1.3  2002/02/28 10:08:54Z  MARTIN
 *  Syntax cleanup for Win32.
 *  Revision 1.2  2002/02/26 14:40:47  MARTIN
 *  Source code cleanup.
 *  Changes for DOS with and without TSR.
 *  Revision 1.1  2002/02/19 13:48:21  MARTIN
 *  Initial revision
 *
 **************************************************************************/

#ifndef _MBGDEVIO_H
#define _MBGDEVIO_H


/* Other headers to be included */

#include <mbg_tgt.h>
#include <pcpsdev.h>
#include <mbggeo.h>
#include <use_pack.h>


#define MBGDEVIO_VERSION         0x0210

#define MBGDEVIO_COMPAT_VERSION  0x0210


#if defined( MBG_TGT_WIN32 )

  #define MBG_USE_KERNEL_DRIVER  1
  #include <windows.h>

#elif defined( MBG_TGT_LINUX )

  #define MBG_USE_KERNEL_DRIVER  1

#elif defined( MBG_TGT_OS2 )

  #define MBG_USE_KERNEL_DRIVER  1

#elif defined( MBG_TGT_DOS )

  #if !defined( MBG_USE_DOS_TSR )
    #define MBG_USE_DOS_TSR  1
  #endif

  #include <pcpsdrvr.h>

#else // other target OSs which access the hardware directly

  #include <pcpsdrvr.h>

#endif

#ifdef _MBGDEVIO
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

#if defined( _USE_PACK )      // set byte alignment
  #pragma pack( 1 )
#endif


#if defined( MBG_TGT_WIN32 )

  typedef HANDLE MBG_DEV_HANDLE;

  #define MBG_INVALID_DEV_HANDLE  INVALID_HANDLE_VALUE

#elif defined( MBG_TGT_LINUX )

  typedef int MBG_DEV_HANDLE;

  #define MBG_INVALID_DEV_HANDLE  -1

#elif defined( MBG_TGT_OS2 )

#else // other target OSs which access the hardware directly

  typedef PCPS_DDEV *MBG_DEV_HANDLE;

  #define MBG_INVALID_DEV_HANDLE  NULL

#endif


#define _mbg_generic_read_var( _dh, _cmd, _s )  \
  mbg_generic_read( _dh, _cmd, &(_s), sizeof( (_s) ) )

#define _mbg_generic_write_var( _dh, _cmd, _s )  \
  mbg_generic_write( _dh, _cmd, &(_s), sizeof( (_s) ) )

#define _mbg_generic_read_gps_var( _dh, _cmd, _s )  \
  mbg_generic_read_gps( _dh, _cmd, &(_s), sizeof( (_s) ) )

#define _mbg_generic_write_gps_var( _dh, _cmd, _s )  \
  mbg_generic_write_gps( _dh, _cmd, &(_s), sizeof( (_s) ) )


/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 _MBG_API_ATTR int _MBG_API mbgdevio_get_version( void ) ;
 _MBG_API_ATTR int _MBG_API mbgdevio_check_version( int header_version ) ;
 _MBG_API_ATTR int _MBG_API mbg_find_devices( void ) ;
 _MBG_API_ATTR MBG_DEV_HANDLE _MBG_API mbg_open_device( unsigned int device_index ) ;
 _MBG_API_ATTR void _MBG_API mbg_close_device( MBG_DEV_HANDLE *dev_handle ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_drvr_info( MBG_DEV_HANDLE dh, PCPS_DRVR_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_device_info( MBG_DEV_HANDLE dh, PCPS_DEV *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_status_port( MBG_DEV_HANDLE dh, PCPS_STATUS_PORT *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_generic_read( MBG_DEV_HANDLE dh, int cmd, void *p, int size ) ;
 _MBG_API_ATTR int _MBG_API mbg_generic_write( MBG_DEV_HANDLE dh, int cmd, const void *p, int size ) ;
 _MBG_API_ATTR int _MBG_API mbg_generic_read_gps( MBG_DEV_HANDLE dh, int cmd, void *p, int size ) ;
 _MBG_API_ATTR int _MBG_API mbg_generic_write_gps( MBG_DEV_HANDLE dh, int cmd, const void *p, int size ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_time( MBG_DEV_HANDLE dh, PCPS_TIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_time( MBG_DEV_HANDLE dh, const PCPS_STIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_sync_time( MBG_DEV_HANDLE dh, PCPS_TIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_time_sec_change( MBG_DEV_HANDLE dh, PCPS_TIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_hr_time( MBG_DEV_HANDLE dh, PCPS_HR_TIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_event_time( MBG_DEV_HANDLE dh, const PCPS_TIME_STAMP *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_serial( MBG_DEV_HANDLE dh, PCPS_SERIAL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_serial( MBG_DEV_HANDLE dh, const PCPS_SERIAL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_tzcode( MBG_DEV_HANDLE dh, PCPS_TZCODE *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_tzcode( MBG_DEV_HANDLE dh, const PCPS_TZCODE *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_pcps_tzdl( MBG_DEV_HANDLE dh, PCPS_TZDL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_pcps_tzdl( MBG_DEV_HANDLE dh, const PCPS_TZDL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_ref_offs( MBG_DEV_HANDLE dh, PCPS_REF_OFFS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_ref_offs( MBG_DEV_HANDLE dh, const PCPS_REF_OFFS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_opt_info( MBG_DEV_HANDLE dh, MBG_OPT_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_opt_settings( MBG_DEV_HANDLE dh, const MBG_OPT_SETTINGS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_irig_rx_info( MBG_DEV_HANDLE dh, IRIG_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_irig_rx_settings( MBG_DEV_HANDLE dh, const IRIG_SETTINGS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_clr_ucap_buff( MBG_DEV_HANDLE dh ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_ucap_entries( MBG_DEV_HANDLE dh, PCPS_UCAP_ENTRIES *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_ucap_event( MBG_DEV_HANDLE dh, PCPS_HR_TIME *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_tzdl( MBG_DEV_HANDLE dh, TZDL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_tzdl( MBG_DEV_HANDLE dh, const TZDL *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_sw_rev( MBG_DEV_HANDLE dh, SW_REV *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_bvar_stat( MBG_DEV_HANDLE dh, BVAR_STAT *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_time( MBG_DEV_HANDLE dh, TTM *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_time( MBG_DEV_HANDLE dh, const TTM *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_port_parm( MBG_DEV_HANDLE dh, PORT_PARM *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_port_parm( MBG_DEV_HANDLE dh, const PORT_PARM *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_ant_info( MBG_DEV_HANDLE dh, ANT_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_ucap( MBG_DEV_HANDLE dh, TTM *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_enable_flags( MBG_DEV_HANDLE dh, ENABLE_FLAGS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_enable_flags( MBG_DEV_HANDLE dh, const ENABLE_FLAGS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_stat_info( MBG_DEV_HANDLE dh, STAT_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_cmd( MBG_DEV_HANDLE dh, const GPS_CMD *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_pos( MBG_DEV_HANDLE dh, POS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_pos_xyz( MBG_DEV_HANDLE dh, const XYZ p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_pos_lla( MBG_DEV_HANDLE dh, const LLA p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_ant_cable_len( MBG_DEV_HANDLE dh, ANT_CABLE_LEN *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_ant_cable_len( MBG_DEV_HANDLE dh, const ANT_CABLE_LEN *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_gps_receiver_info( MBG_DEV_HANDLE dh, RECEIVER_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_gps_port_settings_idx( MBG_DEV_HANDLE dh, const PORT_SETTINGS_IDX *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_setup_receiver_info( MBG_DEV_HANDLE dh, const PCPS_DEV *pdev, RECEIVER_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_serial_settings( MBG_DEV_HANDLE dh, const PCPS_DEV *pdev, RECEIVER_PORT_CFG *pcfg, const RECEIVER_INFO *p_ri ) ;
 _MBG_API_ATTR int _MBG_API mbg_save_serial_settings( MBG_DEV_HANDLE dh, const PCPS_DEV *pdev, RECEIVER_PORT_CFG *pcfg, int port_num ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_asic_version( MBG_DEV_HANDLE dh, PCPS_ASIC_VERSION *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_time_cycles( MBG_DEV_HANDLE dh, PCPS_TIME_CYCLES *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_hr_time_cycles( MBG_DEV_HANDLE dh, PCPS_HR_TIME_CYCLES *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_irig_tx_info( MBG_DEV_HANDLE dh, IRIG_INFO *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_irig_tx_settings( MBG_DEV_HANDLE dh, const IRIG_SETTINGS *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_get_synth( MBG_DEV_HANDLE dh, SYNTH *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_set_synth( MBG_DEV_HANDLE dh, const SYNTH *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_is_gps( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_is_dcf( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_is_irig_rx( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_hr_time( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_cab_len( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_tzdl( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_pcps_tzdl( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_tzcode( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_tz( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_event_time( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_receiver_info( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_can_clr_ucap_buff( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_ucap( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_irig_tx( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_serial_hs( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_signal( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_mod( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_irig( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_ref_offs( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_opt_flags( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_gps_data( MBG_DEV_HANDLE dh, int *p ) ;
 _MBG_API_ATTR int _MBG_API mbg_dev_has_synth( MBG_DEV_HANDLE dh, int *p ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


#if defined( _USE_PACK )   // set default alignment
  #pragma pack()
#endif

/* End of header body */


#undef _ext

#endif  /* _MBGDEVIO_H */

