
/**************************************************************************
 *
 *  $Id: mbg_tgt.h 1.5 2003/12/17 16:11:41Z martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Check the build environment and setup control definitions
 *    for the Meinberg library modules.
 *
 * -----------------------------------------------------------------------
 *  $Log: mbg_tgt.h $
 *  Revision 1.5  2003/12/17 16:11:41Z  martin
 *  Split API modifiers into _MBG_API and _MBG_API_ATTR.
 *  Revision 1.4  2003/06/19 08:20:22Z  martin
 *  Added WINAPI attribute for DLL exported functions.
 *  Revision 1.3  2003/04/09 13:37:20Z  martin
 *  Added definition for _MBG_API.
 *  Revision 1.2  2003/02/24 16:08:45Z  martin
 *  Don't setup for Win32 PNP if explicitely configured non-PNP.
 *  Revision 1.1  2002/02/19 13:46:20Z  MARTIN
 *  Initial revision
 *
 **************************************************************************/

#ifndef _MBG_TGT_H
#define _MBG_TGT_H


/* Other headers to be included */

#ifdef _MBG_TGT
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

#if defined( _WIN32_WINNT )

  // MS platform SDK
  // WinNT 4.0 and above
  #define MBG_TGT_WIN32

  #if ( _WIN32_WINNT >= 0x0500 )
    // Win2k and above
    #if !defined( MBG_TGT_WIN32_NON_PNP )
      // only if not explicitely disabled
      #define MBG_TGT_WIN32_PNP
    #endif
  #endif

#elif defined( WINVER )

  // MS platform SDK
  // Win95, WinNT 4.0 and above
  #define MBG_TGT_WIN32

  #if ( WINVER >= 0x0500 )
    // Win98, Win2k and above
    // #define ...
  #endif

#elif defined( __WIN32__ )

  // Borland C++ Builder
  #define MBG_TGT_WIN32

#elif defined( _WIN32 )

  // MS Visual C++
  #define MBG_TGT_WIN32

#elif defined( __NETWARE_386__ )

  // Watcom C/C++ for target NetWare
  #define MBG_TGT_NETWARE

#elif defined( __OS2__ )

  // Watcom C/C++ for target OS/2
  #define MBG_TGT_OS2

#elif defined( __linux )

  // GCC for target Linux
  #define MBG_TGT_LINUX

#elif defined( __QNX__ )

  // any compiler for target QNX
  #define MBG_TGT_QNX

  #if defined( __QNXNTO__ )
    // target QNX Neutrino
    #define MBG_TGT_QNX_NTO
  #endif

#elif defined( __MSDOS__ )

  // any compiler for target DOS
  #define MBG_TGT_DOS

#endif



#if defined MBG_TGT_WIN32

  #define _MBG_API  WINAPI

  #if defined MBG_LIB_EXPORT
    #define _MBG_API_ATTR __declspec( dllexport )
  #else
    #define _MBG_API_ATTR __declspec( dllimport )
  #endif

#else

  #define _MBG_API
  #define _MBG_API_ATTR

#endif


/* End of header body */

#undef _ext


/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

/* (no header definitions found) */

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


#endif  /* _MBG_TGT_H */
